﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Window.Sample10
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr FindWindowEx(IntPtr parentHwnd, IntPtr childAfterHwnd, string className, string windowTitle);

        [DllImport("user32.dll")]
        public static extern IntPtr FindWindow(string lpClassName, string lpWindowName);

        [DllImport("user32.dll")]
        private static extern bool GetClientRect(IntPtr hWnd, out Rectangle lpRect);

        [DllImport("user32.dll")]
        public static extern bool GetWindowRect(IntPtr hWnd, out Rectangle lpRect);

        [DllImport("user32.dll")]
        public static extern bool MoveWindow(IntPtr hWnd, int x, int y, int nWidth, int nHeight, bool bRepaint);

        public FormMain()
        {
            InitializeComponent();
        }

        private Int32 xPos, yPos, H, W, maxX;
        private IntPtr trayBarHandle;
        private int deltaX = 0;

        private void buttonStart_Click(object sender, EventArgs e)
        {
            IntPtr hWnd = FindWindow("Shell_TrayWnd", null);

            if (hWnd != IntPtr.Zero)
            {
                trayBarHandle = FindWindowEx(hWnd, IntPtr.Zero, "TrayNotifyWnd", null);
                Rectangle rect;

                GetWindowRect(trayBarHandle, out rect);
                xPos = rect.X - 2;
                yPos = 0;
                H = 40;
                W = 169;
                GetClientRect(hWnd, out rect);
                maxX = rect.Width - rect.X - 1 - W;
                timerMover.Start();
                deltaX = -1;
            }
        }

        private void buttonStop_Click(object sender, EventArgs e)
        {
            timerMover.Stop();
        }

        private void timerMover_Tick(object sender, EventArgs e)
        {
            if (trayBarHandle != IntPtr.Zero)
            {
                if (xPos == 0) deltaX = -deltaX;
                if (xPos == maxX) deltaX = -deltaX;
                xPos += deltaX;

                MoveWindow(trayBarHandle, xPos, yPos, W, H, true);
                this.Text = String.Format("X={0} , Y = {1}, W = {2}, H = {3}", xPos, yPos, W, H);
            }
        }
    }
}